package test

import (
	pb "a.yandex-team.ru/infra/hostctl/proto"
	"a.yandex-team.ru/infra/hostctl/units"
	"a.yandex-team.ru/library/go/test/assertpb"
	"testing"
)

func TestRendering_ntp(t *testing.T) {
	f, err := units.Dir.Open("ntp.yaml")
	if err != nil {
		t.Error(err)
	}
	result, err := units.RenderOn(f, "PRESTABLE", "man1-3720.search.yandex.net")
	if err != nil {
		t.Fatal(err)
	}
	expectedSlotMeta := &pb.SlotMeta{
		Annotations: map[string]string{
			"stage":    "stable",
			"filename": "test",
			"env.noop": "True",
		},
	}
	expectedRevMeta := &pb.RevisionMeta{
		Kind:    "SystemService",
		Version: "1:4.2.8p4+dfsg-3ubuntu5.9",
	}
	assertpb.Equal(t, expectedRevMeta, result.RevMeta())
	assertpb.Equal(t, expectedSlotMeta, result.SlotMeta())
	expectedSpec := &pb.SystemServiceSpec{
		Packages: []*pb.SystemPackage{{
			Name:    "ntp",
			Version: "1:4.2.8p4+dfsg-3ubuntu5.9",
		}, {
			Name:    "ntpdate",
			Version: "1:4.2.8p4+dfsg-3ubuntu5.9",
		}},
		Files: []*pb.ManagedFile{{
			Path:    "/etc/systemd/system/ntp.service",
			Content: "[Unit]\nDescription=Set time via NTP\nAfter=syslog.target network.target\nBefore=time-sync.target\nWants=time-sync.target\nBindTo=ntp.service\n\n[Service]\nPIDFile=/var/run/ntp.pid\nType=simple\nExecStart=/usr/sbin/ntpd -g -n -I eth0 -I eth1 -I eth2 -I eth3 -I eth4 -6 --pidfile /var/run/ntp.pid -u ntp:ntp\nRemainAfterExit=no\nRestart=always\n\n[Install]\nWantedBy=multi-user.target\n",
		}, {
			Path:    "/etc/ntp.conf",
			Content: "# generated by saltstack(system/ntp)\ndisable auth\ndisable stats\nserver ntp1.yandex.net\nserver ntp2.yandex.net\nserver ntp3.yandex.net\nserver ntp4.yandex.net\n\ndriftfile /var/lib/ntp/ntp.drift\n",
		}},
	}
	assertpb.Equal(t, expectedSpec, result.Spec())
}
