import jinja2

from ci.tasklet.common.proto import service_pb2 as ci
from infra.infractl.ci_tasklets.get_changelog.proto import get_changelog_tasklet


class GetChangelogImpl(get_changelog_tasklet.GetChangelogBase):
    def run(self):
        request = ci.GetCommitsRequest()
        request.flow_launch_id = self.input.context.job_instance_id.flow_launch_id
        request.limit = 100
        request.type = self.input.config.type

        while True:
            response = self.ctx.ci.GetCommits(request)
            self.output.changelog.commits.extend(response.timeline_commits)

            if not response.HasField('next'):
                break

            request.offset.CopyFrom(response.next)

        template = jinja2.Template(self.input.config.template)
        self.output.changelog.text = template.render(context=self.input.context, commits=self.output.changelog.commits)
