package bootstrap

import (
	"sigs.k8s.io/controller-runtime/pkg/client"

	"a.yandex-team.ru/infra/infractl/cli/commands/bootstrap/internal/objects"
)

type ObjectsMaker interface {
	MakeObjectRefs(isRetry bool) (string, []objects.Ref)
	Make(baseName string) ([]client.Object, error)
	Validate(object client.Object) error
}

type Validator interface {
	Validate(object client.Object) error
}
