package internal

import (
	"log"

	"a.yandex-team.ru/infra/infractl/cli/commands/root"
	yputil "a.yandex-team.ru/infra/infractl/cli/commands/util/yp"
	"a.yandex-team.ru/infra/infractl/clients/abc"
	dclient "a.yandex-team.ru/infra/infractl/internal/deploy/client"
	"a.yandex-team.ru/infra/infractl/internal/secrets"
	"a.yandex-team.ru/infra/infractl/util/kubeutil"
	"a.yandex-team.ru/infra/infractl/util/oauthutil"
)

type Clients struct {
	ypCluster     string
	infractlToken string
	abcClient     *abc.Client
	deployClient  *dclient.DeployClient
	yavClient     *secrets.YavClient
	kubeClient    *kubeutil.Client
}

func NewClients(ypCluster string) *Clients {
	return &Clients{ypCluster: ypCluster}
}

func (g *Clients) token() string {
	if g.infractlToken == "" {
		infractlToken, err := oauthutil.GetToken(root.Context, "INFRACTL_TOKEN")
		if err != nil {
			log.Fatalf("Failed to get Infractl OAuth token: %v", err)
		}
		g.infractlToken = infractlToken
	}
	return g.infractlToken
}

func (g *Clients) Abc() *abc.Client {
	if g.abcClient == nil {
		g.abcClient = abc.NewClient(g.token())
	}
	return g.abcClient
}

func (g *Clients) Deploy() *dclient.DeployClient {
	if g.deployClient == nil {
		g.deployClient = dclient.NewDeployClient(yputil.GetYPClientOrFail(
			g.ypCluster,
			g.token(),
			"INFRACTL_TOKEN",
		), nil, nil)
	}
	return g.deployClient
}

func (g *Clients) Kube() *kubeutil.Client {
	if g.kubeClient == nil {
		c := kubeutil.MakeClient()
		g.kubeClient = &c
	}
	return g.kubeClient
}

func (g *Clients) Yav() *secrets.YavClient {
	if g.yavClient == nil {
		c := secrets.MustCreateClient(g.token())
		g.yavClient = &c
	}
	return g.yavClient
}
