package internal

import (
	"fmt"
	"log"
	"os/user"

	"a.yandex-team.ru/infra/infractl/cli/internal/arcutil"
)

type cliEnv struct {
	User    string
	ArcRoot string
}

func ShowDocsAndDie(format string, a ...any) {
	msg := fmt.Sprintf(format, a...)
	log.Fatalf("%s\nDocumentation: https://docs.yandex-team.ru/infractl/", msg)
}

func MustDetermineCLIUser(userArg string) string {
	if userArg != "" {
		return userArg
	}
	currentUser, err := user.Current()
	if err != nil {
		ShowDocsAndDie("Cannot determine current user. To proceed please set -u/--user argument or USER env var.")
	}
	return currentUser.Username
}

func MustDetectArcadiaRoot() string {
	root, err := arcutil.ArcadiaRoot(".")
	if err != nil {
		ShowDocsAndDie("Cannot detect arcadia root. Please start this command inside arcadia.")
	}
	return root
}

func MustDetectEnv(userArg string) *cliEnv {
	return &cliEnv{
		User:    MustDetermineCLIUser(userArg),
		ArcRoot: MustDetectArcadiaRoot(),
	}
}
