package internal

import (
	"log"

	v1 "k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/runtime/schema"
	"sigs.k8s.io/controller-runtime/pkg/client"

	"a.yandex-team.ru/infra/infractl/cli/commands/root"
	"a.yandex-team.ru/infra/infractl/util/kubeutil"
)

func MustGetNamespace(kubeClient *kubeutil.Client, name string) *v1.Namespace {
	ns := &v1.Namespace{}
	ns.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   v1.SchemeGroupVersion.Group,
		Version: v1.SchemeGroupVersion.Version,
		Kind:    "Namespace",
	})
	ns.Name = name
	err := kubeClient.Get(root.Context, client.ObjectKeyFromObject(ns), ns)
	if err == nil {
		return ns
	}
	if client.IgnoreNotFound(err) == nil {
		log.Fatalf("Namespace %q does not exist", ns.Name)
	}
	log.Fatalf("Failed to check if namespace %q exists: %v", ns.Name, err)
	return nil
}
