package namespace

import (
	"fmt"
	"os/user"

	corev1 "k8s.io/api/core/v1"
	"sigs.k8s.io/controller-runtime/pkg/client"
	crlog "sigs.k8s.io/controller-runtime/pkg/log"

	"a.yandex-team.ru/infra/infractl/cli/commands/bootstrap/internal"
	"a.yandex-team.ru/infra/infractl/cli/commands/root"
	dpv1 "a.yandex-team.ru/infra/infractl/controllers/deploy/api/project/v1"
	"a.yandex-team.ru/infra/infractl/internal/validation"
)

type Validator struct {
	Clients *internal.Clients
}

func (v *Validator) Validate(object client.Object) error {
	ns := object.(*corev1.Namespace)
	currentUser, err := user.Current()
	if err != nil {
		return fmt.Errorf("failed to get current user. Please set USER env variable")
	}
	username := currentUser.Username
	isValid, msg, err := validation.ValidateNamespace(v.Clients.Abc(), crlog.Log, ns, username)
	if err != nil {
		return fmt.Errorf("failed to validate namespace %q: %w", ns.GetName(), err)
	}
	if !isValid {
		return fmt.Errorf(msg)
	}
	return nil
}

type ProjectValidator struct {
	Clients *internal.Clients
	abcSlug string
}

func (v *ProjectValidator) Validate(object client.Object) error {
	prj := object.(*dpv1.DeployProject)
	isValid, msg, err := validation.ValidateProject(root.Context, crlog.Log, v.Clients.Deploy(), v.Clients.Abc(), v.abcSlug, nil, prj)
	if err != nil {
		return fmt.Errorf("failed to validate project %q: %w", prj.GetName(), err)
	}
	if !isValid {
		return fmt.Errorf(msg)
	}
	return nil
}
