package build

import "time"

type SandboxResourceInfo struct {
	FileName string `json:"file_name"`
	Mds      struct {
		URL       string `json:"url"`
		Namespace string `json:"namespace"`
		Key       string `json:"key"`
		BackupURL string `json:"backup_url"`
	} `json:"mds"`
	Owner        string        `json:"owner"`
	ID           uint64        `json:"id"`
	Size         int           `json:"size"`
	Executable   bool          `json:"executable"`
	State        string        `json:"state"`
	ResourceMeta []interface{} `json:"resource_meta"`
	Type         string        `json:"type"`
	SkynetID     string        `json:"skynet_id"`
	HTTP         struct {
		Proxy string   `json:"proxy"`
		Links []string `json:"links"`
	} `json:"http"`
	Description string `json:"description"`
	Rsync       struct {
		Proxy interface{} `json:"proxy"`
		Links []string    `json:"links"`
	} `json:"rsync"`
	Arch string `json:"arch"`
	Md5  string `json:"md5"`
	Task struct {
		Status string `json:"status"`
		URL    string `json:"url"`
		ID     int    `json:"id"`
	} `json:"task"`
	Rights string `json:"rights"`
	URL    string `json:"url"`
	Time   struct {
		Accessed time.Time `json:"accessed"`
		Updated  time.Time `json:"updated"`
		Expires  time.Time `json:"expires"`
		Created  time.Time `json:"created"`
	} `json:"time"`
	Multifile  bool                   `json:"multifile"`
	Attributes map[string]interface{} `json:"attributes"`
}

type SandboxTaskInfo struct {
	MaxRestarts     int         `json:"max_restarts"`
	InputParameters interface{} `json:"input_parameters"`
	Dependant       struct {
		URL   string `json:"url"`
		Count int    `json:"count"`
	} `json:"dependant"`
	Results struct {
		Info      interface{} `json:"info"`
		DiskUsage struct {
			Max  int `json:"max"`
			Last int `json:"last"`
		} `json:"disk_usage"`
	} `json:"results"`
	Intervals struct {
		Queue []struct {
			Duration int       `json:"duration"`
			Start    time.Time `json:"start"`
		} `json:"queue"`
		Execute []struct {
			Duration    int       `json:"duration"`
			Start       time.Time `json:"start"`
			Consumption int       `json:"consumption"`
			Pool        string    `json:"pool"`
		} `json:"execute"`
	} `json:"intervals"`
	LockHost     string        `json:"lock_host"`
	Owner        string        `json:"owner"`
	ID           uint64        `json:"id"`
	TcpdumpArgs  string        `json:"tcpdump_args"`
	SeTags       []interface{} `json:"se_tags"`
	Requirements struct {
		Semaphores        interface{}   `json:"semaphores"`
		ContainerResource interface{}   `json:"container_resource"`
		ClientTags        string        `json:"client_tags"`
		RAM               int           `json:"ram"`
		CPUModel          string        `json:"cpu_model"`
		PortoLayers       []interface{} `json:"porto_layers"`
		Platform          string        `json:"platform"`
		Host              string        `json:"host"`
		DNS               string        `json:"dns"`
		Ramdrive          interface{}   `json:"ramdrive"`
		Cores             int           `json:"cores"`
		DiskSpace         int           `json:"disk_space"`
		TasksResource     interface{}   `json:"tasks_resource"`
		Privileged        bool          `json:"privileged"`
		Resources         struct {
			URL   string        `json:"url"`
			Count int           `json:"count"`
			Ids   []interface{} `json:"ids"`
		} `json:"resources"`
		Caches interface{} `json:"caches"`
	} `json:"requirements"`
	Author            string      `json:"author"`
	SdkVersion        int         `json:"sdk_version"`
	PushTasksResource bool        `json:"push_tasks_resource"`
	ShortTaskResult   interface{} `json:"short_task_result"`
	Priority          struct {
		Class    string `json:"class"`
		Subclass string `json:"subclass"`
	} `json:"priority"`
	Uniqueness struct {
		Key interface{} `json:"key"`
	} `json:"uniqueness"`
	OutputParameters struct {
		Resource int64 `json:"resource"`
	} `json:"output_parameters"`
	Logs []struct {
		URL      string `json:"url"`
		NodeType string `json:"node_type"`
		Name     string `json:"name"`
		Size     int    `json:"size,omitempty"`
	} `json:"logs"`
	Hidden    bool   `json:"hidden"`
	Type      string `json:"type"`
	Resources struct {
		URL   string `json:"url"`
		Count int    `json:"count"`
	} `json:"resources"`
	Status               string        `json:"status"`
	Description          string        `json:"description"`
	Parent               interface{}   `json:"parent"`
	Tags                 []string      `json:"tags"`
	Expires              interface{}   `json:"expires"`
	KillTimeout          int           `json:"kill_timeout"`
	TemplateAlias        interface{}   `json:"template_alias"`
	SuspendOnStatus      []interface{} `json:"suspend_on_status"`
	Notifications        []interface{} `json:"notifications"`
	TasksArchiveResource interface{}   `json:"tasks_archive_resource"`
	Important            interface{}   `json:"important"`
	Tails                []struct {
		URL      string `json:"url"`
		NodeType string `json:"node_type"`
		Name     string `json:"name"`
	} `json:"tails"`
	FailOnAnyError bool          `json:"fail_on_any_error"`
	Scores         int           `json:"scores"`
	SeTag          interface{}   `json:"se_tag"`
	Hints          []interface{} `json:"hints"`
	Audit          struct {
		URL   string `json:"url"`
		Count int    `json:"count"`
	} `json:"audit"`
	Rights   string `json:"rights"`
	URL      string `json:"url"`
	Children struct {
		URL   string `json:"url"`
		Count int    `json:"count"`
	} `json:"children"`
	EnableYav bool `json:"enable_yav"`
	Reports   []struct {
		URL   string `json:"url"`
		Label string `json:"label"`
		Title string `json:"title"`
	} `json:"reports"`
	Hosts struct {
		URL   string `json:"url"`
		Count int    `json:"count"`
	} `json:"hosts"`
	Context struct {
		URL   string `json:"url"`
		Count int    `json:"count"`
	} `json:"context"`
	Time struct {
		Updated time.Time `json:"updated"`
		Created time.Time `json:"created"`
	} `json:"time"`
	Release struct {
		Template struct {
			Cc      interface{} `json:"cc"`
			Message interface{} `json:"message"`
			Types   []string    `json:"types"`
			Subject interface{} `json:"subject"`
		} `json:"template"`
		Resources []struct {
			Releasers  []string `json:"releasers"`
			ResourceID int64    `json:"resource_id"`
		} `json:"resources"`
		WarningMessage string `json:"warning_message"`
	} `json:"release"`
	DumpDiskUsage bool `json:"dump_disk_usage"`
}
