package cmdimport

import "fmt"

type importMode string

const (
	modeFull   importMode = "full"
	modeYAML   importMode = "yaml"
	modeStruct importMode = "struct"
)

func (e *importMode) String() string {
	return string(*e)
}

func (e *importMode) Set(v string) error {
	switch v {
	case string(modeFull), string(modeYAML), string(modeStruct):
		*e = importMode(v)
		return nil
	default:
		return fmt.Errorf(`must be one of "full", "yaml", "struct"`)
	}
}

func (e *importMode) Type() string {
	return "MODE"
}
