package kubeconfig

import (
	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/infractl/internal/environs"
)

func getContextAliasesMap() map[string]string {
	rv := make(map[string]string)
	for _, e := range environs.Environs {
		for _, alias := range e.ConfigOpts.ContextAliases {
			rv[alias] = e.ConfigOpts.Context
		}
	}
	return rv
}

func KubeConfig() *cobra.Command {
	cmd := &cobra.Command{
		Use:              "kubeconfig",
		Short:            "Special settings and utilities",
		TraverseChildren: true,
	}
	cmd.AddCommand(SetupKubeConfig())
	cmd.AddCommand(UseContext())
	return cmd
}
