package cmdmake

import (
	"log"
	"path/filepath"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/infractl/cli/internal/arcutil"
	"a.yandex-team.ru/infra/infractl/cli/internal/iyaml"
	"a.yandex-team.ru/infra/infractl/cli/internal/serialization"
	"a.yandex-team.ru/infra/infractl/util/kubeutil"
)

func Make() *cobra.Command {
	var arcPath string
	cmd := &cobra.Command{
		Use:   "make",
		Short: "Render specs using patches and generators specified in i.yaml",
		Args:  cobra.MaximumNArgs(1),
		Run: func(cmd *cobra.Command, args []string) {
			rootManifest := "."
			if len(args) == 1 {
				rootManifest = args[0]
			}
			rootManifest, err := filepath.Abs(rootManifest)
			if err != nil {
				log.Fatalf("Unable to find manifest root: %v", err)
			}

			arcRoot, _, err := arcutil.ArcadiaRootAndYa(arcPath)
			if err != nil {
				log.Fatalf("Unable to find arcadia root: %v", err)
			}

			kubeClient := kubeutil.MakeClient()

			p := iyaml.NewManifestProcessor(arcRoot, kubeClient)
			br, err := p.Build(rootManifest)
			if err != nil {
				log.Fatalf("Specs compilation failed: %v", err)
			}
			if err := p.SetNamespaceIfNeeded(br); err != nil {
				log.Fatalf("Specs compilation failed: %v", err)
			}
			if err := serialization.DumpObjectsToStdout(br.GetObjects()); err != nil {
				log.Fatalf("Dumping to stdout failed: %v", err)
			}
		},
	}

	cmd.Flags().StringVarP(&arcPath, "arc-path", "a", ".", "arcadia root path")
	return cmd
}
