package put

import (
	"fmt"

	"k8s.io/apimachinery/pkg/runtime"

	prv1 "a.yandex-team.ru/infra/infractl/controllers/runtime/api/proto_v1"
	rv1 "a.yandex-team.ru/infra/infractl/controllers/runtime/api/v1"
	"a.yandex-team.ru/infra/infractl/internal/quantities"
)

func fillRuntimeDefaults(rt *rv1.Runtime) error {
	spec := rt.GetSpec()
	if spec == nil {
		return nil
	}

	if spec.Storage == nil {
		spec.Storage = &prv1.Spec_Storage{
			StorageClass: "hdd",
			Quota:        "4G",
		}
	}

	if spec.Compute == nil {
		spec.Compute = &prv1.Spec_ComputeResources{}
	}
	if len(spec.Compute.Vcpu) == 0 {
		spec.Compute.Vcpu = "1000"
	}
	if len(spec.Compute.Memory) == 0 {
		spec.Compute.Memory = "1G"
	}
	if len(spec.Compute.Net) == 0 {
		spec.Compute.Net = "15M"
	}

	// TODO (torkve) volumes with their storages ain't supported in runtime yet,
	//               nor they are supported here.
	if len(spec.Storage.IoBandwidth) == 0 {
		var multiplier, atLeastMbps uint64
		if spec.Storage.StorageClass == "hdd" {
			multiplier = 2
			atLeastMbps = 15
		} else {
			multiplier = 5
			atLeastMbps = 30
		}

		res := spec.GetCompute()
		vcpu, err := quantities.ConvertFromHuman(res.GetVcpu())
		if err != nil {
			return fmt.Errorf("cannot fill IO defaults: invalid vcpu: %w", err)
		}

		totalMbps := vcpu * multiplier / 1000
		if totalMbps < atLeastMbps {
			totalMbps = atLeastMbps
		}

		spec.Storage.IoBandwidth = fmt.Sprintf("%vM", totalMbps)
	}
	return nil
}

func fillDefaultValues(unspec runtime.Object) error {
	switch spec := unspec.(type) {
	case *rv1.Runtime:
		return fillRuntimeDefaults(spec)
	}
	return nil
}
