package put

import (
	"testing"

	"github.com/stretchr/testify/assert"

	prv1 "a.yandex-team.ru/infra/infractl/controllers/runtime/api/proto_v1"
	rv1 "a.yandex-team.ru/infra/infractl/controllers/runtime/api/v1"
)

func Test_fillRuntimeDefaults(t *testing.T) {
	rt := &rv1.Runtime{Spec: &prv1.Spec{}}

	err := fillRuntimeDefaults(rt)
	if !assert.NoError(t, err) {
		return
	}

	assert.Equal(t, "1000", rt.Spec.Compute.Vcpu)
	assert.Equal(t, "1G", rt.Spec.Compute.Memory)
	assert.Equal(t, "15M", rt.Spec.Compute.Net)

	assert.Equal(t, "hdd", rt.Spec.Storage.StorageClass)
	assert.Equal(t, "4G", rt.Spec.Storage.Quota)
	assert.Equal(t, "15M", rt.Spec.Storage.IoBandwidth)
}
