package root

import (
	"context"
	"fmt"
	"os"
	"path/filepath"

	"github.com/spf13/cobra"
	"k8s.io/client-go/util/homedir"

	"a.yandex-team.ru/infra/infractl/internal/kubeconfig"
)

var (
	Context = context.Background()
)

func ValidFile(_ *cobra.Command, args []string) error {
	for _, arg := range args {
		stat, err := os.Stat(arg)
		if err != nil {
			return fmt.Errorf("cannot stat file %q: %v", arg, err)
		}
		if stat.IsDir() {
			return fmt.Errorf("path is a directory, file expected: %q", arg)
		}
	}
	return nil
}

func MakeCmd(name, description string) *cobra.Command {
	cmd := &cobra.Command{
		Use:              name,
		Long:             description,
		TraverseChildren: true,
	}
	defaultConfig := filepath.Join(homedir.HomeDir(), ".kube", "config")

	// TODO (torkve) we probably should not use kubeconfig, we can build-in cluster configurations
	cmd.PersistentFlags().StringVar(&kubeconfig.Path, "kubeconfig", defaultConfig, "path to kubectl config file")

	return cmd
}
