package yp

import (
	"fmt"
	"log"

	"a.yandex-team.ru/infra/infractl/cli/commands/root"
	"a.yandex-team.ru/infra/infractl/util/oauthutil"
	"a.yandex-team.ru/yp/go/yp"
)

type YpCluster string

const (
	XDC     YpCluster = "xdc"
	ManPre  YpCluster = "man-pre"
	SasTest YpCluster = "sas-test"
)

func (e *YpCluster) String() string {
	return string(*e)
}
func (e *YpCluster) Set(v string) error {
	switch v {
	case string(XDC), string(ManPre), string(SasTest):
		*e = YpCluster(v)
		return nil
	default:
		return fmt.Errorf(`must be one of "sas-test", "man-pre", or "xdc"`)
	}
}
func (e *YpCluster) Type() string {
	return "CLUSTER"
}

func GetYPClientOrFail(c string, ypToken string, envVarName string) *yp.Client {
	if len(ypToken) == 0 {
		var err error
		ypToken, err = oauthutil.GetToken(root.Context, envVarName)
		if err != nil {
			log.Fatalf("YP access token is not given\n" +
				"Please get you YP access token from: " +
				"https://oauth.yandex-team.ru/authorize?response_type=token&client_id=1ffc8f7c4cc440ebbb2fddd6a333f8a9 " +
				"and put it into YP_TOKEN env variable")
		}
	}

	ypClient, err := yp.NewClient(c, yp.WithAuthToken(ypToken))
	if err != nil {
		log.Fatalf("Failed to create YP connection: %v", err)
	}
	return ypClient
}
