package deploystage

import (
	"fmt"

	deployclient "a.yandex-team.ru/infra/infractl/internal/deploy/client"
	"a.yandex-team.ru/yp/go/proto/podagent"
	"a.yandex-team.ru/yp/go/proto/ypapi"
)

func DeduceDeployUnit(spec *ypapi.TStageSpec, candidate string) (duID string, du *ypapi.TDeployUnitSpec, err error) {
	if len(candidate) == 0 {
		if len(spec.DeployUnits) != 1 {
			return "", nil, fmt.Errorf("not specified deploy_unit_id, but spec is ambigous: %v deploy units found", len(spec.DeployUnits))
		}
		// Just take the only one map value
		for duIDVal, duVal := range spec.DeployUnits {
			du = duVal
			duID = duIDVal
		}
	} else {
		du = spec.DeployUnits[candidate]
		duID = candidate
		if du == nil {
			return "", nil, fmt.Errorf("deploy unit %q not found", candidate)
		}
	}
	return
}

func DeduceResource(
	spec *ypapi.TDeployUnitSpec,
	candidate string,
	plug Resource,
) (resourceID string, resource Resource, err error) {
	podSpec := GetPodAgentSpec(spec)
	resources := plug.FetchResources(podSpec)
	if len(resources) != 1 && len(candidate) == 0 {
		return "", nil, fmt.Errorf("not specified %v id, but spec is ambiguous: %v %vs found", plug.GetResourceName(), len(resources), plug.GetResourceName())
	}
	for _, rsc := range resources {
		if len(candidate) == 0 || rsc.GetID() == candidate {
			return rsc.GetID(), rsc, nil
		}
	}
	return "", nil, fmt.Errorf("%v %q not found", plug.GetResourceName(), candidate)
}

func DeduceBox(spec *ypapi.TDeployUnitSpec, candidate string) (boxID string, box *podagent.TBox, err error) {
	podSpec := GetPodAgentSpec(spec)
	boxes := podSpec.GetBoxes()

	if len(boxes) != 1 && len(candidate) == 0 {
		return "", nil, fmt.Errorf("not specified box_id, but spec is ambigous: %v boxes found", len(boxes))
	}
	for _, box := range boxes {
		if len(candidate) == 0 || box.Id == candidate {
			return box.Id, box, nil
		}
	}
	return "", nil, fmt.Errorf("box %q not found", candidate)
}

func DeduceWorkload(
	du *ypapi.TDeployUnitSpec,
	candidate string,
	boxRef string,
) (workloadID string, workload *podagent.TWorkload, err error) {
	podSpec := GetPodAgentSpec(du)
	workloads := podSpec.GetWorkloads()

	if len(workloads) != 1 && len(candidate) == 0 {
		return "", nil, fmt.Errorf(
			"not specified workload_id, but spec is ambigous: %v workloads found",
			len(workloads),
		)
	}

	for _, workload := range workloads {
		if len(boxRef) != 0 && workload.BoxRef != boxRef {
			continue
		}

		if len(candidate) == 0 || workload.Id == candidate {
			return workload.Id, workload, nil
		}
	}

	return "", nil, fmt.Errorf("workload %q not found", candidate)
}

func GetPodAgentSpec(spec *ypapi.TDeployUnitSpec) *podagent.TPodAgentSpec {
	podSpec := deployclient.GеtPodSpec(spec)
	if podSpec == nil {
		return nil
	}
	return podSpec.GetPodAgentPayload().GetSpec()
}
