package deploystage

import (
	"a.yandex-team.ru/yp/go/proto/podagent"
)

type Resource interface {
	GetID() string
	GetSandboxResource() *podagent.TSandboxResource
	FetchResources(podSpec *podagent.TPodAgentSpec) []Resource
	GetResourceName() string
	SetDefaultFieldsNull()
}

type Layer struct {
	*podagent.TLayer
}

func (l *Layer) SetDefaultFieldsNull() {
	l.Checksum = ""
	l.Meta = nil
	l.DownloadMethod = nil
}

func (l *Layer) GetID() string {
	return l.Id
}

func (l *Layer) GetSandboxResource() *podagent.TSandboxResource {
	return l.Meta.GetSandboxResource()
}

func (l *Layer) GetResourceName() string {
	return "layer"
}

func (l *Layer) FetchResources(podSpec *podagent.TPodAgentSpec) []Resource {
	layers := podSpec.GetResources().GetLayers()
	result := make([]Resource, len(layers))
	for i, layer := range layers {
		result[i] = &Layer{layer}
	}
	return result
}

type StaticResource struct {
	*podagent.TResource
}

func (l *StaticResource) SetDefaultFieldsNull() {
	l.Meta = nil
	l.DownloadMethod = nil
}

func (l *StaticResource) GetResourceName() string {
	return "static resource"
}

func (l *StaticResource) GetID() string {
	return l.Id
}
func (l *StaticResource) GetSandboxResource() *podagent.TSandboxResource {
	return l.Meta.GetSandboxResource()
}

func (l *StaticResource) FetchResources(podSpec *podagent.TPodAgentSpec) []Resource {
	statics := podSpec.GetResources().GetStaticResources()
	result := make([]Resource, len(statics))
	for i, rsc := range statics {
		result[i] = &StaticResource{rsc}
	}
	return result
}
