package substitutio

import (
	"gopkg.in/yaml.v3"
)

const (
	BuildManifestAnnotation = "deploystage.infractl.k.yandex-team.ru/buildManifest"
)

type DockerPackageRef struct {
	DeployUnitID string `yaml:"deploy_unit_id,omitempty" json:"deploy_unit_id,omitempty"`
	BoxID        string `yaml:"box_id,omitempty" json:"box_id,omitempty"`
	Path         string `yaml:"path" json:"path"`
}

type LayerRef struct {
	DeployUnitID string `yaml:"deploy_unit_id,omitempty" json:"deploy_unit_id,omitempty"`
	LayerID      string `yaml:"layer_id,omitempty" json:"layer_id,omitempty"`
	Path         string `yaml:"path" json:"path"`
}

type StaticResourceRef struct {
	DeployUnitID     string `yaml:"deploy_unit_id,omitempty" json:"deploy_unit_id,omitempty"`
	StaticResourceID string `yaml:"static_resource_id,omitempty" json:"static_resource_id,omitempty"`
	Path             string `yaml:"path" json:"path"`
}

type StageBuildManifest struct {
	DockerPackages  []DockerPackageRef  `yaml:"docker_packages" json:"docker_packages"`
	Layers          []LayerRef          `yaml:"layers" json:"layers"`
	StaticResources []StaticResourceRef `yaml:"static_resources" json:"static_resources"`
}

func LoadBuildManifest(annotation string) (manifest *StageBuildManifest, err error) {
	manifest = &StageBuildManifest{}
	err = yaml.Unmarshal([]byte(annotation), manifest)
	if err != nil {
		manifest = nil
	}
	return
}

type ManifestFiller interface {
	FillManifest(manifest *StageBuildManifest, duID, resolvedDuID, resolvedSandboxResourceID, resourceID, path string)
}
type StaticResourceFiller struct{}
type LayerFiller struct{}

func (l *StaticResourceFiller) FillManifest(manifest *StageBuildManifest, duID, resolvedDuID, resolvedSandboxResourceID, resourceID, path string) {
	var foundIndx *int
	for i, manifestStaticResource := range manifest.StaticResources {
		if (manifestStaticResource.DeployUnitID == duID || manifestStaticResource.DeployUnitID == resolvedDuID) &&
			(manifestStaticResource.StaticResourceID == resourceID || manifestStaticResource.StaticResourceID == resolvedSandboxResourceID) {
			foundIndx = &i
			break
		}
	}
	if foundIndx != nil {
		manifest.StaticResources[*foundIndx] = manifest.StaticResources[len(manifest.StaticResources)-1]
		manifest.StaticResources = manifest.StaticResources[:len(manifest.StaticResources)-1]
	}
	manifest.StaticResources = append(manifest.StaticResources, StaticResourceRef{
		DeployUnitID:     duID,
		StaticResourceID: resourceID,
		Path:             path,
	})
}

func (l *LayerFiller) FillManifest(manifest *StageBuildManifest, duID, resolvedDuID, resolvedSandboxResourceID, resourceID, path string) {
	for i, manifestLayer := range manifest.Layers {
		if (manifestLayer.DeployUnitID == duID || manifestLayer.DeployUnitID == resolvedDuID) &&
			(manifestLayer.LayerID == resourceID || manifestLayer.LayerID == resolvedSandboxResourceID) {
			manifest.Layers = append(manifest.Layers[:i], manifest.Layers[i+1:]...)
			break
		}
	}

	manifest.Layers = append(manifest.Layers, LayerRef{
		DeployUnitID: duID,
		LayerID:      resourceID,
		Path:         path,
	})
}
