package substitutio

import (
	"github.com/ghodss/yaml"
	"k8s.io/apimachinery/pkg/runtime"
	"sigs.k8s.io/controller-runtime/pkg/client"
)

const (
	TemplateAnnotation      = "object.infractl.k.yandex-team.ru/template"
	SubstitutionsAnnotation = "object.infractl.k.yandex-team.ru/substitutions"
	KubectlApplyAnnotation  = "kubectl.kubernetes.io/last-applied-configuration"
)

type Templatable interface {
	ClearStatus()
}

func DumpTemplate(unspec runtime.Object) ([]byte, error) {
	objCopy := unspec.DeepCopyObject()
	if clientObj, ok := objCopy.(client.Object); ok {
		annotations := clientObj.GetAnnotations()
		delete(annotations, TemplateAnnotation)
		delete(annotations, SubstitutionsAnnotation)
		delete(annotations, KubectlApplyAnnotation)
	}
	if templateObj, ok := objCopy.(Templatable); ok {
		templateObj.ClearStatus()
	}

	return yaml.Marshal(objCopy)
}
