package main

import (
	"log"
	"runtime"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/infractl/cli/commands/bootstrap"
	"a.yandex-team.ru/infra/infractl/cli/commands/build"
	"a.yandex-team.ru/infra/infractl/cli/commands/create"
	cmdimport "a.yandex-team.ru/infra/infractl/cli/commands/import"
	"a.yandex-team.ru/infra/infractl/cli/commands/kubeconfig"
	cmdmake "a.yandex-team.ru/infra/infractl/cli/commands/make"
	"a.yandex-team.ru/infra/infractl/cli/commands/modify"
	"a.yandex-team.ru/infra/infractl/cli/commands/pull"
	"a.yandex-team.ru/infra/infractl/cli/commands/put"
	"a.yandex-team.ru/infra/infractl/cli/commands/root"
	_ "a.yandex-team.ru/infra/infractl/internal/scheme"
)

func setupProcess() {
	// 4 seems to be a reasonable value to make a good parallelism if needed,
	// but keep OS unharmed enough if "something goes wrong"
	runtime.GOMAXPROCS(4)
}

/* setupTermLog sets flags to build golang logger disabling all extra fields,
   leaving only message itself. As this logger is used and intended for terminal messages
   only. */
func setupTermLog() {
	log.SetFlags(0)
}

func registerSubcommands(cmd *cobra.Command) {
	// cmd.AddCommand(cmdinit.Init())
	cmd.AddCommand(bootstrap.Bootstrap())
	cmd.AddCommand(build.Build())
	cmd.AddCommand(create.Create())
	cmd.AddCommand(modify.Modify())
	// cmd.AddCommand(apply.Apply())
	// cmd.AddCommand(list.List())
	// cmd.AddCommand(sync.Sync())
	// cmd.AddCommand(add.Add())
	cmd.AddCommand(pull.Pull())
	cmd.AddCommand(put.Put())
	// cmd.AddCommand(purge.Purge())
	cmd.AddCommand(cmdimport.Import())
	cmd.AddCommand(kubeconfig.KubeConfig())
	cmd.AddCommand(cmdmake.Make())
}

func main() {
	setupProcess()
	setupTermLog()
	cmd := root.MakeCmd("infractl", "Yandex project infrastructure control")
	registerSubcommands(cmd)

	err := cmd.Execute()
	if err != nil {
		log.Fatal(err)
	}
}
