package blackbox

import (
	"context"

	"a.yandex-team.ru/library/go/yandex/blackbox"
	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb"
	"a.yandex-team.ru/library/go/yandex/tvm"
)

type Client struct {
	blackbox.Client
}

type LoginFromOauthGetter interface {
	GetLoginFromOauth(ctx context.Context, oauth string, userip string) (string, uint64, error)
}

func MakeClient(tvmClient tvm.Client, opts ...httpbb.Option) (Client, error) {
	opts = append([]httpbb.Option{httpbb.WithTVM(tvmClient)}, opts...)
	bb, err := httpbb.NewIntranet(opts...)
	return Client{bb}, err
}

func (c Client) GetLoginFromOauth(ctx context.Context, oauth string, userip string) (string, uint64, error) {
	resp, err := c.OAuth(ctx, blackbox.OAuthRequest{
		OAuthToken: oauth,
		UserIP:     userip,
	})
	if err != nil {
		return "", 0, err
	}

	return resp.User.Login, resp.User.UID.ID, nil
}
