package idm

import "fmt"

type IdmError struct {
	ErrorCode string `json:"error_code,omitempty"`
	Message   string `json:"message,omitempty"`
}
type ErrorResponse struct {
	IdmError
	StatusCode int
}

func (e ErrorResponse) Error() string {
	return fmt.Sprintf("Request failed with %d: %s", e.StatusCode, e.IdmError.Message)
}
