package idm

import (
	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/core/log/zap"
)

type option interface {
	configure(c *resty.Client) *resty.Client
}

type withToken struct {
	Token string
}

func (t *withToken) configure(c *resty.Client) *resty.Client {
	return c.
		SetAuthScheme("OAuth").
		SetAuthToken(t.Token)
}

func WithToken(token string) option {
	return &withToken{Token: token}
}

type withLogger struct {
	Logger resty.Logger
}

func (t *withLogger) configure(c *resty.Client) *resty.Client {
	return c.SetLogger(t.Logger)
}

func WithLogger(logger *zap.Logger) option {
	return &withLogger{Logger: logger}
}

type withURL struct {
	URL string
}

func (t *withURL) configure(c *resty.Client) *resty.Client {
	return c.SetBaseURL(t.URL)
}

func WithURL(url string) option {
	return &withURL{URL: url}
}
