// Package idm: all fields description try to find here https://wiki.yandex-team.ru/intranet/idm/API/public/

package idm

import "time"

type RuEnString struct {
	Ru string `json:"ru,omitempty"`
	En string `json:"en,omitempty"`
}

type User struct {
	DateJoined         string     `json:"date_joined,omitempty"`
	Email              string     `json:"email,omitempty"`
	FiredAt            *time.Time `json:"fired_at,omitempty"`
	FullName           string     `json:"full_name,omitempty"`
	IsActive           bool       `json:"is_active,omitempty"`
	IsRobot            bool       `json:"is_robot,omitempty"`
	NotifyResponsibles bool       `json:"notify_responsibles,omitempty"`
	Position           string     `json:"position,omitempty"`
	Sex                *string    `json:"sex,omitempty"`
	Type               string     `json:"type,omitempty"`
	Username           string     `json:"username,omitempty"`
}

type Group struct {
	CreatedAt *time.Time `json:"created_at,omitempty"`
	ID        uint64     `json:"id,omitempty"`
	Name      string     `json:"name,omitempty"`
	Slug      string     `json:"slug,omitempty"`
	State     string     `json:"state,omitempty"`
	Type      string     `json:"type,omitempty"`
	UpdatedAt *time.Time `json:"updated_at,omitempty"`
	URL       string     `json:"url,omitempty"`
}

type Permissions struct {
	CanBeApproved      bool `json:"can_be_approved,omitempty"`
	CanBeDeprived      bool `json:"can_be_deprived,omitempty"`
	CanBePokedIfFailed bool `json:"can_be_poked_if_failed,omitempty"`
	CanBeRerequested   bool `json:"can_be_rerequested,omitempty"`
}

type Role struct {
	Added           *time.Time   `json:"added,omitempty"`
	Data            interface{}  `json:"data,omitempty"`
	ExpireAt        *time.Time   `json:"expire_at,omitempty"`
	FieldsData      interface{}  `json:"fields_data,omitempty"`
	GrantedAt       *time.Time   `json:"granted_at,omitempty"`
	Group           *Group       `json:"group,omitempty"`
	Human           string       `json:"human,omitempty"`
	HumanShort      string       `json:"human_short,omitempty"`
	HumanState      string       `json:"human_state,omitempty"`
	ID              uint64       `json:"id,omitempty"`
	IsActive        bool         `json:"is_active,omitempty"`
	IsPublic        *bool        `json:"is_public,omitempty"`
	Node            interface{}  `json:"node,omitempty"`
	Parent          *Role        `json:"parent,omitempty"`
	Permissions     *Permissions `json:"permissions,omitempty"`
	RefCount        int          `json:"ref_count,omitempty"`
	ReviewAt        *time.Time   `json:"review_at,omitempty"`
	ReviewDate      *time.Time   `json:"review_date,omitempty"`
	ReviewDays      *int         `json:"review_days,omitempty"`
	RoleRequest     interface{}  `json:"role_request,omitempty"`
	State           string       `json:"state,omitempty"`
	System          interface{}  `json:"system,omitempty"`
	SystemSpecific  interface{}  `json:"system_specific,omitempty"`
	TTLDate         *time.Time   `json:"ttl_date,omitempty"`
	TTLDays         *int         `json:"ttl_days,omitempty"`
	Updated         *time.Time   `json:"updated,omitempty"`
	User            *User        `json:"user,omitempty"`
	WithExternal    bool         `json:"with_external,omitempty"`
	WithInheritance bool         `json:"with_inheritance,omitempty"`
	WithRobots      bool         `json:"with_robots,omitempty"`
	WithoutHold     bool         `json:"without_hold,omitempty"`
}

type Approver struct {
	Fullname string `json:"fullname,omitempty"`
	Username string `json:"username,omitempty"`
}

type RoleRequestSimulated struct {
	Approvers [][]Approver `json:"approvers"`
	TTLDays   *int         `json:"ttl_days"`
}

type RequestRoleReq struct {
	Simulate         bool                   `json:"simulate,omitempty"`
	User             string                 `json:"user,omitempty"`
	GroupID          uint64                 `json:"group,omitempty"`
	System           string                 `json:"system"`
	Path             string                 `json:"path"`
	FieldsData       map[string]interface{} `json:"fields_data,omitempty"`
	Comment          string                 `json:"comment,omitempty"`
	DepriveAt        *time.Time             `json:"deprive_at,omitempty"`
	ReviewAt         *time.Time             `json:"review_at,omitempty"`
	DepriveAfterDays int                    `json:"deprive_after_days,omitempty"`
	Silent           bool                   `json:"silent,omitempty"`
}

type RequestRoleRsp struct {
	*Role
	Simulated *RoleRequestSimulated `json:"simulated,omitempty"`
}
