package api

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	cfg "sigs.k8s.io/controller-runtime/pkg/config/v1alpha1"
)

// ControllerConfig is the Schema for the controllerconfigs API
type ControllerConfig struct {
	metav1.TypeMeta                        `json:",inline"`
	cfg.ControllerManagerConfigurationSpec `json:",inline"`

	Unistat UnistatConfig     `json:"unistat"`
	Options ReconcilerOptions `json:"options"`
}

type UnistatConfig struct {
	Path string `json:"path"`
}

type ReconcilerOptions struct {
	AwacsAPI string `json:"awacsAPI"`
	YavTvmID uint64 `json:"yavTvmID"`
	TvmID    uint64 `json:"tvmID"`
}
