package controllers

import (
	"context"

	"github.com/go-logr/logr"
	corev1 "k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/types"

	"a.yandex-team.ru/infra/infractl/internal/secrets"
)

func getAwacsToken(
	r secrets.SecretReader,
	ctx context.Context,
	log logr.Logger,
	namespaceName string,
	selfTvmID uint64,
) (string, error) {
	var namespace corev1.Namespace
	if err := r.GetK8sClient().Get(ctx, types.NamespacedName{Namespace: "", Name: namespaceName}, &namespace); err != nil {
		log.Error(err, "failed to fetch namespace")
		return "", err
	}
	token, err := secrets.LoadProviderToken(r, ctx, &namespace, "awacs", selfTvmID)
	if err != nil {
		// Could not load token with new token storage mechanics, will use legacy one
		token, err = secrets.LoadToken(r, ctx, &namespace, secrets.TokensSecretNameV2, secrets.TokensSecretUUIDLabelKey, secrets.AwacsTokenYavKey)
		if err != nil {
			log.Error(err, "failed to load awacs token")
			return "", err
		}
	}
	return token, nil
}
