package v1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	cfg "sigs.k8s.io/controller-runtime/pkg/config/v1alpha1"
)

// ControllerConfig is the Schema for the controllerconfigs API
type ControllerConfig struct {
	metav1.TypeMeta                        `json:",inline"`
	cfg.ControllerManagerConfigurationSpec `json:",inline"`

	Unistat UnistatConfig     `json:"unistat"`
	Options ReconcilerOptions `json:"options"`
}

type UnistatConfig struct {
	Path string `json:"path"`
}

type ReconcilerOptions struct {
	YpClusterName string `json:"ypClusterName"`
	YavTvmID      uint64 `json:"yavTvmID"`
	TvmID         uint64 `json:"tvmID"`
	TemplateURL   string `json:"templateURL"`
	DevMode       bool   `json:"devMode"`
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ReconcilerOptions) DeepCopyInto(out *ReconcilerOptions) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ReconcilerOptions.
func (in *ReconcilerOptions) DeepCopy() *ReconcilerOptions {
	if in == nil {
		return nil
	}
	out := new(ReconcilerOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ControllerConfig) DeepCopyInto(out *ControllerConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ControllerManagerConfigurationSpec.DeepCopyInto(&out.ControllerManagerConfigurationSpec)
	out.Unistat = in.Unistat
	out.Options = in.Options
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ControllerConfig.
func (in *ControllerConfig) DeepCopy() *ControllerConfig {
	if in == nil {
		return nil
	}
	out := new(ControllerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ControllerConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UnistatConfig) DeepCopyInto(out *UnistatConfig) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UnistatConfig.
func (in *UnistatConfig) DeepCopy() *UnistatConfig {
	if in == nil {
		return nil
	}
	out := new(UnistatConfig)
	in.DeepCopyInto(out)
	return out
}
