package main

import (
	"testing"

	"github.com/stretchr/testify/assert"

	types "a.yandex-team.ru/infra/infractl/controllers/deploy/api/stage/proto_v1"
	"a.yandex-team.ru/yp/go/proto/ypapi"
)

func TestSpecDeepCopy(t *testing.T) {
	spec := types.Spec{
		StageSpec: &ypapi.TStageSpec{
			Revision:    42,
			DeployUnits: make(map[string]*ypapi.TDeployUnitSpec),
		},
	}
	spec.StageSpec.DeployUnits["a"] = &ypapi.TDeployUnitSpec{
		Revision: 43,
	}

	newSpec := spec.DeepCopy()
	assert.NotEqual(t, nil, newSpec.StageSpec, "Spec is nil")
	assert.Equal(t, spec.StageSpec.Revision, newSpec.StageSpec.Revision, "Revision not copied")
	assert.NotEqual(t, nil, newSpec.StageSpec.DeployUnits["a"], "DeployUnit not copied")
	assert.Equal(t, spec.StageSpec.DeployUnits["a"].Revision, newSpec.StageSpec.DeployUnits["a"].Revision, "DeployUnit revision no copied")

	spec.StageSpec.Revision = 44
	spec.StageSpec.DeployUnits["a"].Revision = 45

	assert.NotEqual(t, spec.StageSpec.Revision, newSpec.StageSpec.Revision, "Revision links to same object")
	assert.NotEqual(t, spec.StageSpec.DeployUnits["a"].Revision, newSpec.StageSpec.DeployUnits["a"].Revision, "DeployUnit links to same object")
}
