package ypproject

import (
	"google.golang.org/protobuf/proto"

	"a.yandex-team.ru/yp/go/proto/ypapi"
	"a.yandex-team.ru/yt/go/proto/core/ytree"
)

type YPProject struct {
	project       *ypapi.TProject
	specTimestamp uint64
}

func NewYPProject(project *ypapi.TProject, ypSpecTimestamp uint64) *YPProject {
	return &YPProject{
		project:       project,
		specTimestamp: ypSpecTimestamp,
	}
}

func (p *YPProject) GetID() string {
	return p.project.GetMeta().GetId()
}

func (p *YPProject) GetFqid() string {
	return p.project.GetMeta().GetFqid()
}

func (p *YPProject) GetYPSpecTimestamp() uint64 {
	return p.specTimestamp
}

func (p *YPProject) GetYPObject() proto.Message {
	return p.project
}

func (p *YPProject) GetYPSpec() proto.Message {
	return p.project.GetSpec()
}

func (p *YPProject) GetYPAnnotations() *ytree.TAttributeDictionary {
	return p.project.GetAnnotations()
}

func (p *YPProject) GetYPMeta() interface{} {
	return p.project.GetMeta()
}

func (p *YPProject) GetAccountID() string {
	return p.project.GetMeta().GetAccountId()
}
