package ypstage

import (
	"google.golang.org/protobuf/proto"

	"a.yandex-team.ru/yp/go/proto/ypapi"
	"a.yandex-team.ru/yt/go/proto/core/ytree"
)

type YPStage struct {
	stage           *ypapi.TStage
	specTimestamp   uint64
	revisionComment string
}

func NewYPStage(stage *ypapi.TStage, ypSpecTimestamp uint64, revisionComment string) *YPStage {
	return &YPStage{
		stage:           stage,
		specTimestamp:   ypSpecTimestamp,
		revisionComment: revisionComment,
	}
}

func (s *YPStage) setRevisionComment(spec *ypapi.TStageSpec) {
	if spec.GetRevisionInfo() == nil {
		spec.RevisionInfo = &ypapi.TStageSpec_TRevisionInfo{}
	}
	spec.RevisionInfo.Description = s.revisionComment
}

func (s *YPStage) GetID() string {
	return s.stage.GetMeta().GetId()
}

func (s *YPStage) GetFqid() string {
	return s.stage.GetMeta().GetFqid()
}

func (s *YPStage) GetYPSpecTimestamp() uint64 {
	return s.specTimestamp
}

func (s *YPStage) GetYPObject() proto.Message {
	// s.stage.Spec is referred to kObj.Spec.StageSpec. We cannot change k8s objects, because of some side effects of
	// Reconcile, so we need to copy
	stage := s.stage.DeepCopy()
	s.setRevisionComment(stage.Spec)
	return stage
}

func (s *YPStage) GetYPSpec() proto.Message {
	spec := s.stage.Spec.DeepCopy()
	s.setRevisionComment(spec)
	return spec
}

func (s *YPStage) GetYPAnnotations() *ytree.TAttributeDictionary {
	return s.stage.GetAnnotations()
}
func (s *YPStage) GetYPMeta() interface{} {
	return s.stage.GetMeta()
}

func (s *YPStage) GetAccountID() string {
	return s.stage.GetMeta().GetAccountId()
}
