package internal

import (
	"a.yandex-team.ru/infra/infractl/internal/deploy/interfaces"
	"a.yandex-team.ru/yt/go/proto/core/ytree"
	"a.yandex-team.ru/yt/go/yson"
)

type infractlAnnotation struct {
	Generation int64 `yson:"generation"`
}

func getInfractlAnnotation(dObj interfaces.DeployObject) (*infractlAnnotation, error) {
	annotationValue := findAnnotation(dObj.GetYPAnnotations(), "infractl")
	annotation := &infractlAnnotation{}
	if err := yson.Unmarshal(annotationValue, annotation); err != nil {
		return nil, err
	}
	return annotation, nil
}

func findAnnotation(annotations *ytree.TAttributeDictionary, key string) []byte {
	for _, a := range annotations.GetAttributes() {
		if a.GetKey() == key {
			return a.GetValue()
		}
	}
	return nil
}
