package internal

import (
	"context"

	"a.yandex-team.ru/infra/infractl/internal/deploy/interfaces"
)

type DeployClient interface {
	Fetch(
		ctx context.Context,
		timestamp uint64,
		kObj interfaces.KubernetesObject,
	) (interfaces.DeployObject, error)
	Create(
		ctx context.Context,
		kObj interfaces.KubernetesObject,
		dObj interfaces.DeployObject,
	) (uint64, error)
	Update(
		ctx context.Context,
		kObj interfaces.KubernetesObject,
		dObj interfaces.DeployObject,
		curYPSpecTimestamp uint64,
	) (uint64, error)
}

type DeployObjectWrapper struct {
	interfaces.DeployObject
	Fqid string
}

func (d DeployObjectWrapper) GetFqid() string {
	return d.Fqid
}
