package v1

import (
	"google.golang.org/protobuf/proto"

	"a.yandex-team.ru/yp/go/proto/ypapi"
	"a.yandex-team.ru/yt/go/proto/core/ytree"
)

type YPMultiClusterReplicaSet struct {
	mcrs          *ypapi.TMultiClusterReplicaSet
	specTimestamp uint64
}

func NewYPMultiClusterReplicaSet(mcrs *ypapi.TMultiClusterReplicaSet, ypSpecTimestamp uint64) *YPMultiClusterReplicaSet {
	return &YPMultiClusterReplicaSet{
		mcrs:          mcrs,
		specTimestamp: ypSpecTimestamp,
	}
}

func (p *YPMultiClusterReplicaSet) GetAccountID() string {
	return p.mcrs.GetMeta().GetAccountId()
}

func (p *YPMultiClusterReplicaSet) GetID() string {
	return p.mcrs.GetMeta().GetId()
}

func (p *YPMultiClusterReplicaSet) GetFqid() string {
	return p.mcrs.GetMeta().GetFqid()
}

func (p *YPMultiClusterReplicaSet) GetYPSpecTimestamp() uint64 {
	return p.specTimestamp
}

func (p *YPMultiClusterReplicaSet) GetYPObject() proto.Message {
	return p.mcrs
}

func (p *YPMultiClusterReplicaSet) GetYPMeta() interface{} {
	return p.mcrs.GetMeta()
}

func (p *YPMultiClusterReplicaSet) GetYPSpec() proto.Message {
	return p.mcrs.GetSpec()
}

func (p *YPMultiClusterReplicaSet) GetYPAnnotations() *ytree.TAttributeDictionary {
	return p.mcrs.GetAnnotations()
}
