package v1

import (
	"fmt"
	"testing"

	"github.com/go-playground/assert/v2"
)

func TestMakeCommandLine(t *testing.T) {
	_, err := makeCommandLine([]string{})
	assert.Equal(t, err, fmt.Errorf("command is empty"))

	command, _ := makeCommandLine([]string{"bin/sleep", "333"})
	assert.Equal(t, "bin/sleep 333", command)

	command, _ = makeCommandLine([]string{"/bin/bash", "-c", "echo OK"})
	assert.Equal(t, `/bin/bash -c "echo OK"`, command)
}
