package v1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/runtime"
	cfg "sigs.k8s.io/controller-runtime/pkg/config/v1alpha1"
)

// ControllerConfig is the Schema for the controllerconfigs API
type ControllerConfig struct {
	metav1.TypeMeta                        `json:",inline"`
	cfg.ControllerManagerConfigurationSpec `json:",inline"`

	Unistat UnistatConfig     `json:"unistat"`
	Options ReconcilerOptions `json:"options"`
}

type UnistatConfig struct {
	Path string `json:"path"`
}
type ReconcilerOptions struct {
	TemplateURL string `json:"templateURL"`
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ControllerConfig) DeepCopyInto(out *ControllerConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ControllerManagerConfigurationSpec.DeepCopyInto(&out.ControllerManagerConfigurationSpec)
	out.Unistat = in.Unistat
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ControllerConfig.
func (in *ControllerConfig) DeepCopy() *ControllerConfig {
	if in == nil {
		return nil
	}
	out := new(ControllerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ControllerConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UnistatConfig) DeepCopyInto(out *UnistatConfig) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UnistatConfig.
func (in *UnistatConfig) DeepCopy() *UnistatConfig {
	if in == nil {
		return nil
	}
	out := new(UnistatConfig)
	in.DeepCopyInto(out)
	return out
}
