package controllers

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"sigs.k8s.io/controller-runtime/pkg/controller/controllerutil"

	rv1 "a.yandex-team.ru/infra/infractl/controllers/runtime/api/v1"
	psev1 "a.yandex-team.ru/infra/infractl/models/serviceendpoint/proto_v1"
	sev1 "a.yandex-team.ru/infra/infractl/models/serviceendpoint/v1"
)

func (r *RuntimeReconciler) MakeEmptyServiceEndpoint(kRuntime *rv1.Runtime) (kServiceEndpoint *sev1.ServiceEndpoint, err error) {
	kServiceEndpointName := makeName(rv1.NamespacedName(kRuntime), "serviceendpoint")

	kServiceEndpoint = sev1.NewServiceEndpoint()
	kServiceEndpoint.ObjectMeta = metav1.ObjectMeta{
		Name:        kServiceEndpointName.Name,
		Namespace:   kServiceEndpointName.Namespace,
		Generation:  1,
		Labels:      map[string]string{},
		Annotations: map[string]string{},
	}
	kServiceEndpoint.Spec = &psev1.Spec{}
	kServiceEndpoint.Status = &psev1.Status{}
	if err = controllerutil.SetControllerReference(kRuntime, kServiceEndpoint, r.Scheme); err != nil {
		kServiceEndpoint = nil
	}
	return
}
