package controllers

import (
	"net/http"

	"sigs.k8s.io/controller-runtime/pkg/log"

	"a.yandex-team.ru/library/go/yandex/unistat"
	"a.yandex-team.ru/library/go/yandex/unistat/aggr"
)

type Stats struct {
	SyncCount   *unistat.Numeric
	SyncErrors  *unistat.Numeric
	SyncLatency *unistat.Histogram
}

func MakeStats() *Stats {
	stats := &Stats{
		SyncCount:  unistat.NewNumeric("sync-count", 1, aggr.Counter(), unistat.Sum),
		SyncErrors: unistat.NewNumeric("sync-errors", 1, aggr.Counter(), unistat.Sum),
		SyncLatency: unistat.NewHistogram("sync-latency", 1, aggr.Histogram(),
			[]float64{0, 25, 50, 75, 100, 500, 1000, 5000, 10000}),
	}
	unistat.Register(stats.SyncCount)
	unistat.Register(stats.SyncErrors)
	unistat.Register(stats.SyncLatency)

	return stats
}

func (srv *Stats) ServeHTTP(rw http.ResponseWriter, req *http.Request) {
	bytes, err := unistat.MarshalJSON()
	if err != nil {
		http.Error(rw, err.Error(), http.StatusInternalServerError)
		return
	}

	rw.Header().Set("Content-Type", "application/json; charset=utf-8")
	if _, err := rw.Write(bytes); err != nil {
		log := log.FromContext(req.Context())
		log.Error(err, "Failed to send response")
	}
}
