from textwrap import dedent, indent


def write_deep_copy_into(name, has_spec, has_status):
    print(dedent(
        f"""\
        // DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. o must be non-nil.
        func (o *{name}) DeepCopyInto(out *{name}) {{
            *out = *o
            out.TypeMeta = o.TypeMeta
            o.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
        """
    ))
    if has_spec:
        print(indent(dedent(
            """\
            if o.Spec != nil {
                in, out := &o.Spec, &out.Spec
                *out = (*in).DeepCopy()
            }
            """
        ), '    '))
    if has_status:
        print(indent(dedent(
            """\
            if o.Status != nil {
                in, out := &o.Status, &out.Status
                *out = (*in).DeepCopy()
            }
            """
        ), '    '))
    print("}\n")


def write_deep_copy(name):
    print(dedent(
        f"""\
        // DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new {name}.
        func (o *{name}) DeepCopy() *{name} {{
            if o == nil {{
                return nil
            }}
            out := new({name})
            o.DeepCopyInto(out)
            return out
        }}
        """
    ))


def write_deep_copy_object(name):
    print(dedent(
        f"""\
        // DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
        func (o *{name}) DeepCopyObject() runtime.Object {{
            if c := o.DeepCopy(); c != nil {{
                return c
            }}
            return nil
        }}
        """
    ))


def write_list_deep_copy_into(name):
    print(dedent(
        f"""\
        // DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. o must be non-nil.
        func (o *{name}List) DeepCopyInto(out *{name}List) {{
            *out = *o
            out.TypeMeta = o.TypeMeta
            o.ListMeta.DeepCopyInto(&out.ListMeta)
            if o.Items != nil {{
                in, out := &o.Items, &out.Items
                *out = make([]{name}, len(*in))
                for i := range *in {{
                    (*in)[i].DeepCopyInto(&(*out)[i])
                }}
            }}
        }}
        """
    ))


def write_list_deep_copy(name):
    print(dedent(
        f"""\
        // DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new {name}List.
        func (o *{name}List) DeepCopy() *{name}List {{
            if o == nil {{
                return nil
            }}
            out := new({name}List)
            o.DeepCopyInto(out)
            return out
        }}
        """
    ))


def write_list_deep_copy_object(name):
    print(dedent(
        f"""\
        // DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
        func (o *{name}List) DeepCopyObject() runtime.Object {{
            if c := o.DeepCopy(); c != nil {{
                return c
            }}
            return nil
        }}
        """
    ))
