# Используемые концепции

## Namespace

В Kubernetes неймспейс является основной единицей группировки объектов. Мы используем их для описания проектов: к каждому неймспейсу обязан быть привязан abc-сервис, и права выдаются на неймспейс целиком.

При трансляции объектов в Yandex Deploy имя неймспейса автоматически используется в качестве имени проекта Deploy, над которым мы оперируем.

## DeployStage

Объект DeployStage является специальным видом объекта Kubernetes (CRD), описывающим спеку стейджа в Deploy. Эта спека транслируется в Deploy от имени робота, чей токен был проделегирован в k8s при создании соответствующего неймспейса.

Такие поля как `project_id` и `id` заполняются автоматически на основе имени неймспейса и имени объекта DeployStage, соответственно.

## Как работает подстановка артефактов

В качестве артефактов в Deploy используются два вида объектов: образ Docker и Sandbox-ресурс.
Мы позволяем указывать эти объекты в генерализованном виде: вместо конкретного имени образа или данных о ресурсе в спецификации хранится специальный манифест, описывающий, какие пакеты необходимо собрать и в качестве каких Docker-образов или слоёв подставить.

Эти пакеты указываются в качестве пути к package.json файлу в Аркадии, что позволяет найти происхождение ресурса и собрать их заново.

Собранные ресурсы сохраняются в специальный билд-файл (с именем `.build.yaml` по умолчанию). При необходимости его можно также сохранять в VCS.

## Манифест сборки (i.yaml)

```
service level               i.yaml
	                .../  |  \...
	                      |
	                      |
	                      |
project level               i.yaml
                           /  |   \
                          /   |    \
                         /    |     \
stage level         i.yaml i.yaml i.yaml


```

Манифест представляет из себя описание сборки спецификации списка объектов. Обычно он используется для дедупликации или разделения на смысловые части. Сборка происходит с помощью команды [infractl make](cli.md#make).

Сборка представляет из себя прохождение пути в графе зависимостей, в каждом из узлов которого выполняются два действия: сборка ресурсов и применение патчей. [Подробнее](manifest.md)

