# infractl

Позволяет управлять сервисами, живущими во [внутреннем облаке](https://docs.yandex-team.ru/rtc/) Яндекса, с помощью хранимого в репозитории текстового описания.

## Для чего подходит? {#current-goals}

Пока что лишь для переноса в текстовый формат уже запущенных в [Yandex.Deploy](https://docs.yandex-team.ru/deploy/) сервисов. Предоставляя инструменты для хранения сервисов в Аркадии, infractl даёт возможность:
* Менять их с помощью привычных средств редактирования кода
* Проводить ревью изменений стандартным для Аркадии способом
* Выкладывать через [CI](https://docs.yandex-team.ru/ci/) любые настройки сервисов, а не только исполняемые артефакты
* Зафиксировать в сервисах ссылки на таргеты сборки их артефактов
* Вынести одинаковые настройки сервисов, уменьшив число ошибок из-за дублирования

## Для чего не подходит? {#current-non-goals}

Пока что infractl не позволяет быстро и легко разворачивать новые сервисы. Мы активно работаем над этой [проблемой](https://clubs.at.yandex-team.ru/infra-cloud/1922) и итеративно приближаемся к её решению, начав с хранения сервисов в Аркадии. Следующий шаг на этом пути: возможность управлять через infractl балансерами, а в дальнейшем и другими запчастями сервисов, настраиваемыми вне Yandex.Deploy.

Единственный формат описания сервиса, который сейчас поддерживает infractl, это стейджи Yandex.Deploy. Их схема данных обладает высокой гибкостью и выразительностью, что позволяет поднимать сервисы с широким спектром требований. Однако это приводит и к большой сложности структуры их описания. Иными словами, спеки даже относительно простых стейджей Yandex.Deploy [не всегда просто читать](https://a.yandex-team.ru/arc/trunk/arcadia/infra/dproxy/infractl/kustomize/build/prod.yaml?rev=r9270236). Поэтому сложность настройки сервиса при его переносе в текстовое описание в большой доле сценариев вырастет по сравнению с работой через UI. Решить эту проблему призвана easy-mode схема сервиса с балансером в сжатом и простом виде.

Указанные проблемы и будут главной точкой приложения наших сил на ближайшее время.

{% note warning %}

infractl пока находится на стадии прохождения аудита безопасности, поэтому под него не рекомендуется переносить критически важные сервисы.

{% endnote %}

## Что появится в ближайшие кварталы? {#nearest-future}

* Управление [awacs-балансерами](https://wiki.yandex-team.ru/awacs/) через текстовое описание
* Easy-mode схема сервиса с балансером в сжатом простом виде и возможность тривиально поднимать простые сервисы с её помощью

## Какие есть способы шаблонизации в infractl? {#customization}

infractl поддерживает [kustomize](https://kustomize.io/) как простейший способ конфигурации сервисов с общими настройками. Возможности `kustomize` ограничены и покрывают лишь несложные сценарии доопределения базовых настроек кастомными, [пример из howto](https://docs.yandex-team.ru/infractl/howto#multiple-stages). Генерацию описаний сервисов императивным кодом пока что можно построить только снаружи infractl, однако в будущем мы поддержим её в платформенных инструментах.

## Что планируем поддержать в будущем? {#farest-future}

* Полокационную выкладку
* Генерация описаний сервисов императивным кодом
* Просмотр всех запчастей сервиса через дашборд в веб-интерфейсе
* Управление сервисами под SOX-аудитом
* Указание зависимостей между сервисами для настройки сетевого взаимодействия: запроса доступов, конфигурации окружения и service mesh
* Возможность вводить собственные объекты, описывающие запчасти в любых системах
* Возможность описывать собственные типов сервисов с нужным для конкретной задачи уровнем гибкости

## Полезные ссылки {#links}

[Чат поддержки](https://t.me/+VdEooUIOJbo4ZDVi)
[Очередь в st](https://st.yandex-team.ru/INFRACTL)


{% note tip %}

_По любым вопросам, с пожеланиями, критикой, а также для сотрудничества обращайтесь к [команде проекта](https://abc.yandex-team.ru/services/infractl/)._

{% endnote %}

