Безопасный доступ к пользовательским секретам
=============================================

## Решаемая проблема

Контроллерам необходимо выполнять какие-то действия с объектами в системе провайдеров.

Мы считаем, что с одной стороны для разграничения доступов действия должны выполняться с использованием credentials, предоставленных пользователем (токен некоего робота, имеющего права к системе).

С другой стороны обращение с этими секретами должно быть безопасным и со стороны контроллера: код контроллера может быть недостаточно доверенным и необходимо предотвратить угон секретов пользователя и какой-то масштабный ущерб с их применением.

### Терминология

**Провайдер** — система, сущностями в которой планируется управлять. Например: Deploy, Nanny, Awacs.

**Контроллер** — микросервис, читающий объекты определённого типа из k8s и выполняющий какие-то действия с провайдером или самим k8s.

**Пользователь** — аккаунт, создающий объекты в k8s.

**Робот** — аккаунт-владелец секрета. От имени этого аккаунта контроллер взаимодействует с провайдером при работе с соответствующими сущностями.

## Предлагаемое решение

### Разделение контроллеров

На первом этапе мы разделяем контроллеры на две группы: доверенные (разработанные и аудируемые командой infractl) и недоверенные.

К доверенным контроллерам мы предъявляем меньшие требования: считаем, что в них риск кражи пользовательских токенов и данных не стои́т и нет необходимости скрывать выданные пользователем credentials от контроллера.

При этом данное разделение является временным и служит исключительно упрощению, никакая дополнительная логика в доверенных контроллерах на этом основываться не может. В дальнейшем доверенные контроллеры могут быть переведены на общую недоверенную схему.

### Разделение секретов

В целях разграничения прав credentials для доступа к каждому провайдеру делегируются пользователем в независимый секрет в [yav][yav], после чего delegation-токен и имя секрета сохраняются в секрете k8s.

Чтобы доверенный контроллер мог использовать секрет, для него создаётся `RoleBinding`, позволяющий контроллеру прямое использование секрета. Недоверенным контроллерам никаких прав не даём.

### Изоляция секретов от недоверенных контроллеров

В идеальном случае у нас должен быть универсальный gateway, проксирующий все запросы к провайдеру, обогащая их авторизационными данными.
В реальной ситуации такой провайдер написать довольно затруднительно, учитывая многообразие всех видов протоколов, авторизации и балансировки.

В связи с этим предлагается всё-таки предоставлять контроллерам доступ, но делать это ограниченно, в том числе по времени.

Для этого мы пишем более простой gateway, который убеждается, что пользователь разрешил контроллеру доступ к соответствующему секрету.
Для удобства пользователя мы можем автоматически выдавать такой доступ в момент, когда пользователь заливает в k8s объект, управляемый данным контроллером — кажется, что это явно сигнализирует о намерении.

После этого gateway выписывает [TVM user ticket](https://wiki.yandex-team.ru/passport/tvm2/user-ticket/) и отдаёт его контроллеру.
Таким образом в худшем случае утекает только тикет, которым можно пользоваться ограниченное время и это не потребует перевыпуска секретов.

В данной схеме всем провайдерам придётся научиться принимать user tickets.

#### Как проверять, разрешено ли контроллеру обращаться за user ticket

В k8s есть механизм проверки наличия прав `SubjectAccessReview` [[1]](https://unofficial-kubernetes.readthedocs.io/en/latest/admin/authorization/#request-payloads)[[2]](https://docs.openshift.com/container-platform/3.7/rest_api/apis-authorization.k8s.io/v1.SubjectAccessReview.html).

Можно в качестве выдачи прав выписывать `RoleBinding` для контроллера на какой-нибудь псевдоресурс, а в gateway для проверки прав делать запрос `SubjectAccessReview`, выясняя, выданы ли контроллеру соответствующие права.

Примерная модель взаимодействия:

1. **Пользователь** `TheUser` получает роботный секрет **провайдера** `TheProvider` (обычно OAuth-токен), записывает его в отдельный секрет в [yav][yav].
2. **Пользователь** `TheUser` создаёт привязанный к неймспейсу `TheNamespace` своего сервиса секрет k8s с фиксированным именем вида `infractl.TheProvider.token`, в который записывает имя и delegation token секрета yav. На этом этапе вероятна выдача явного разрешения использования этого секрета **гейтвеем** — чтобы не давать гейтвею доступ вообще ко всем секретам.
3. **Пользователь** `TheUser` разрешает **контроллеру** `TheController` использование секрета. Для этого он создаёт роль, указывающую на фиктивный ресурс:
   ```yaml
   apiVersion: rbac.authorization.k8s.io/v1
   kind: Role
   metadata:
     namespace: TheNamespace
     name: infractl.TheProvider.token
   rules:
   - apiGroups:
     - fake.group
     resources:
     - secrets
     resourceNames:
     - 'infractl.TheProvider.token.usage'
     verbs:
     - get

   ----
   apiVersion: rbac.authorization.k8s.io/v1
   kind: RoleBinding
   metadata:
     namespace: TheNamespace
     name: infractl.TheProvider.use-by.TheController
   roleRef:
     apiGroup: rbac.authorization.k8s.io
     kind: Role
     name: infractl.TheProvider.token
   subjects:
   - apiGroup: rbac.authorization.k8s.io
     kind: User
     name: <TheController.TVM_ID>
   ```
4. **Контроллер** `TheController` обращается к **гейтвею**:
   ```
   POST /get-user-ticket/
   X-Ya-Service-Ticket: <redacted>
   Content-Type: application/json
   Content-Length: ...

   {
       "namespace": "TheNamespace",
       "provider": "TheProvider"
   }
   ```
5. **Гейтвей** получает из сервис-тикета TVM ID и проверяет права:
   ```json
   {
       "apiVersion": "authorization.k8s.io/v1beta1",
       "kind": "SubjectAccessReview",
       "spec": {
           "resourceAttributes": {
               "namespace": "TheNamespace",
               "verb": "get",
               "group": "fake.group",
               "resource": "infractl.TheProvider.token"
            },
            "user": "<TheController.TVM_ID",
        }
   }
   ```
   В качестве ответа он получает ресурс со статусом:
   ```json
   {
       ...
       "status": {"allowed": true}
   }
   ```
6. Если проверка прав успешна, **гейтвей** достаёт из секрета `infractl.TheProvider.token` токен, меняет его в blackbox на User Ticket и возвращает в ответе **контроллеру** `TheController`.

В реальной имплементации для реализации этой схемы непосредственно **пользователю** потребуется выполнить 1-2 действия:
1. Получить токен **робота** для доступа к **провайдеру** `TheProvider`. На данный момент это полностью ручное действие, которое требует авторизоваться соответствующим роботом. Как мы обсуждали с [Андреем Красичковым](https://staff.yandex-team.ru/buglloc), в будущем возможно удастся сделать заказ к Паспорту, чтобы пользователь мог по своему SSH-ключу получать токены роботов, которыми имеет право управлять. Тогда этот пункт можно будет автоматизировать и вмержить в следующий.
2. Выполнить команду вида `infractl delegate --token <TOKEN> --provider TheProvider`.

Делегирование **контроллеру** `TheController` токена **провайдера** `TheProvider` мы сможем выполнять прозрачно на стороне infractl cli в тот момент, когда **пользователь** сделает `put` на ресурс того вида, которым управляет `TheController`.

### Альтернативные и метаконтроллеры

Контроллер может хотеть управлять провайдером, для которого уже есть стандартный контроллер, например, на основании какой-то сложной логики создавать/управлять стейджами в Deploy.

У него есть три пути:

1. Просить у пользователя отдельный независимый секрет, например, для собственного приложения. В таком случае можно считать, что контроллер управляет отдельной системой и задача целиком сводится к предыдущему разделу.
2. Просить у пользователя выписать разрешение на секрет соответствующей системы. Можно неявно — при `infractl put` метаобъекта контроллера, при условии, что соответствующий секрет уже присутствует в k8s. Далее, как и в предыдущем разделе, получать user tickets для работы.
3. Не использовать секреты вообще: контроллер обрабатывает метаспецификацию и создаёт/обновляет необходимые примитивы в k8s, а над этими примитивами уже будут работать соответствующие контроллеры с правами. В таком варианте пользователю необходимо будет разрешить контроллеру создание соответствующих примитивов, а в момент их создания контроллером ролей добавлять `RoleBinding`, позволяющий редактировать созданное им.

## Нерешённые проблемы

### Как делегировать секреты провайдерам

Пользователю требуется делегировать секреты в нижележащие системы, в первую очередь в YP, т.е., например, разрешать использовать определённый секрет в стейдже.

Очевидно, что контроллер соответствующих объектов не имеет отношения к данным секретам и по идее не должен иметь непосредственной возможности их прочитать. Но в существующей модели ACL это приводит к дилемме: либо контроллер должен иметь права на все упоминаемые пользователем в объектах секреты, чтобы делегировать их в системах провайдера, либо в системе будут вынуждены протекать абстракции: после того, как контроллер создаст все необходимые объекты в провайдере, пользователь должен будет сходить напрямую в провайдер и проделегировать права.

Достаточно хорошим решением было бы выделение отдельной роли «управляющий инфраструктурой», которая давала бы права на делегирование, но не давала прав чтения. Соответственно эта роль должна быть поддержана в [yav][yav] и всех требуемых провайдерах.

На текущий момент существует один провайдер (YP), для которого эта проблема стоит остро, и мы считаем, что наш доверенный контроллер над Ya.Deploy достаточно безопасен и аудируем, чтобы пока что можно было пойти по первому пути и потребовать от пользователя делегирвать все используемые секреты контроллеру даже несмотря на то что они не нужны ему для работы.

[yav]: https://yav.yandex-team.ru
