# Хранение секретов

{% note info %}

Подробное описание модели секретов доступно в [RFC](rfcs/secrets.md).

{% endnote %}

## Владельцы секретов

Все действия с внешними системами (провайдерами) infractl выполняет с использованием токенов, явно переданных пользователем. Для каждого провайдера в [неймспейсе](concepts.md#namespace) сохраняется один отдельный секрет, в котором хранится указание на Yav-секрет с токеном, и прозвольное количество секретов, в каждом из которых хранится delegation token для приложения, которому вы разрешаете воспользоваться данным секретом.

Все секреты пользователь размещает в k8s от собственного имени, однако сам токен настоятельно рекомендуется получать от имени робота, заведённого специально для вашего сервиса. Это гарантирует, что сервис не сломается, когда пользователь уволится или перейдёт в другую команду.

## Выдача прав

Мы максимально упростили для пользователи процесс выдачи прав (и стремимся в будущем сделать его даже ещё проще).

Для официально поддерживаемых на данный момент провайдеров (YP и awacs) и управляющих их объектами контроллеров мы реализовали [специальную команду](cli.md#delegate), выполняющую за пользователя все операции, кроме непосредственно получения токена робота. Для выбранного провайдера она создаёт секрет в Yav, выбирает соответствующие TVM-приложения и делегирует для них токен, после чего создаёт необходимый набор секретов в k8s.

Таким образом, для пользователя все действия сводятся к двум пунктам (на примере YP):

1. Получить токен робота по ссылке, предложенной командой `ya tool infractl modify delegate yp` без параметров.
2. Сохранить этот токен при помощии команды: `YP_TOKEN="..." ya tool infractl modify delegate yp -f infra.namespace.yaml`

### Механика выдачи прав

Рассмотрим, как вышеописанная процедура работает, на конкретном примере: пользователь `someuser` хочет с помощью infractl управлять выкладкой стейджей своего сервиса в Ya.Deploy.

Для этого он в нашей модели делает следующее:

1. Получает токен для работы с YP для робота `robot-someservice`, которому выданы права на Deploy-проект `someproject`.
2. Размещает этот токен в отдельном Yav-секрете. Например, `sec-111111111111`.
3. Сохраняет идентификатор этого секрета в специальном именованном k8s-секрете, содержащем имя провайдера (yp): `infractl-tokens-yp`.
4. Делегирует Yav-секрет для использования теми системами, которые будут осуществлять выкладку. То есть, для TVM-приложения `2033927`, под которым работает продакшен-инсталляция контроллера стейджей.
5. Кладёт полученный delegation token в специальный k8s-секрет, содержащий имя провайдера (yp) и id TVM-приложения (2033927): `infractl-delegation-token-yp-2033927`.

При этом администраторы k8s ограничивают права чтения секрета `infractl-delegation-token-yp-2033927` только упомянутым контроллером.

Таким образом доступ выдаётся гранулированно и при наличии провайдеров, с которыми могут работать различные контроллеры, возможно выдать права только тем контроллерам, которые требуются пользователю.
