package client

import (
	"context"
	"fmt"
	"strings"

	"a.yandex-team.ru/infra/infractl/internal/deploy/interfaces"
	"a.yandex-team.ru/yp/go/yp"
)

func (c *DeployClient) ValidateUseAccountIDPermission(
	ctx context.Context,
	username string,
	accountID string,
	abcSlug string, // used only for human-readable error message
	kObj interfaces.KubernetesObject,
) (bool, string, error) {
	req := yp.CheckObjectPermissionsRequest{
		Permissions: []yp.CheckObjectPermission{
			{
				ObjectID:   accountID,
				SubjectID:  username,
				ObjectType: yp.ObjectTypeAccount,
				Permission: yp.AccessControlPermissionUse,
			},
		},
	}
	rsp, err := c.ypClient.CheckObjectPermissions(ctx, req)
	if err != nil {
		return false, "", err
	}

	oType := strings.ToLower(kObj.GetReadableObjectType())
	msg := fmt.Sprintf(
		"User %q is not a member of ABC account %q specified in %s %q",
		username, abcSlug, oType, kObj.GetName(),
	)
	for _, perm := range rsp.Permissions {
		if perm.ObjectType == yp.ObjectTypeAccount && perm.ObjectID == accountID {
			if perm.Action != yp.AccessControlActionAllow {
				return false, msg, nil
			}
			return true, "", nil
		}
	}
	return false, msg, nil
}
