package client

import (
	"context"
	"fmt"

	corev1 "k8s.io/api/core/v1"

	"a.yandex-team.ru/infra/infractl/internal/secrets"
	"a.yandex-team.ru/yp/go/yp"
)

func InitYpClientWithToken(
	ctx context.Context,
	reader secrets.SecretReader,
	namespace *corev1.Namespace,
	ypCluster string,
	selfTvmID uint64,
) (client *yp.Client, err error) {

	var token string
	token, err = secrets.LoadProviderToken(reader, ctx, namespace, "yp", selfTvmID)
	if err != nil {
		token, err = secrets.LoadToken(reader, ctx, namespace, secrets.TokensSecretNameV2, secrets.TokensSecretUUIDLabelKey, secrets.YpTokenYavKey)
		if err != nil {
			token, err = secrets.LoadToken(reader, ctx, namespace, secrets.TokensSecretName, secrets.YpTokenSecretUUIDLabelKey, secrets.YpTokenYavKey)
			if err != nil {
				err = fmt.Errorf("failed to load deploy token: %w", err)
				return
			}
		}
	}
	client, err = yp.NewClient(
		ypCluster,
		yp.WithAuthToken(token),
		// orm.WithLogger(log), // TODO(torkve) need to adapt logr to arcadian logger somehow
	)
	return
}
