package interfaces

import (
	"google.golang.org/protobuf/proto"
	"sigs.k8s.io/controller-runtime/pkg/client"

	commonv1proto "a.yandex-team.ru/infra/infractl/controllers/deploy/api/common/proto_v1"
	"a.yandex-team.ru/library/go/yandex/unistat"
	"a.yandex-team.ru/yp/go/yp"
	"a.yandex-team.ru/yt/go/proto/core/ytree"
)

type DeployObject interface {
	GetID() string
	GetFqid() string
	GetAccountID() string
	GetYPMeta() interface{}
	GetYPSpecTimestamp() uint64
	GetYPObject() proto.Message
	GetYPSpec() proto.Message
	GetYPAnnotations() *ytree.TAttributeDictionary
}

type KubernetesObject interface {
	client.Object
	GetObjectType() yp.ObjectType
	GetReadableObjectType() string
	GetFqid() string
	GetAccountID() string // used in validation in order not to create DeployObject
	GetSyncStatus() *commonv1proto.SyncStatus
	IsStatusEqualTo(kObj KubernetesObject) (bool, error)
	SpecNewer(generation int64) bool
	MakeURL(template string) string
	FillDeployObject(response *yp.GetObjectResponse) (DeployObject, error)
	ValidateDeployObject(dObj DeployObject) (string, error)
	SetStatus(dObj DeployObject) error
	SetFqid(fqid string)
}

type DeployObjectMaker interface {
	Make(kObj KubernetesObject, prevDobj DeployObject) (DeployObject, error)
}

type UnistatUpdater interface {
	GetSyncLatency() *unistat.Histogram
	UpdateSyncErrors(value float64)
	UpdateSyncCount(value float64)
}
