package environs

import (
	"fmt"
	"strconv"

	"a.yandex-team.ru/infra/infractl/internal/kubeconfig"
)

type configOptions struct {
	Cluster        string
	Server         string
	User           string
	Context        string
	ContextAliases []string
}

type Environ struct {
	OAuthClientID     string
	OAuthClientSecret string
	TvmAliases        map[string][]uint64
	ConfigOpts        *configOptions
}

var ProdEnviron = &Environ{
	OAuthClientID:     "1ffc8f7c4cc440ebbb2fddd6a333f8a9",
	OAuthClientSecret: "62b2f2dc83944f14a1b9a8e9660d7c59",
	ConfigOpts: &configOptions{
		Cluster:        "k.yandex-team.ru",
		Server:         "https://k.yandex-team.ru",
		User:           "k.yandex-team.ru",
		Context:        "k.yandex-team.ru",
		ContextAliases: []string{"k"},
	},
	TvmAliases: map[string][]uint64{
		"deployctl": {2033927, 2032622},
		"awacsctl":  {2035691, 2032622},
	},
}

var DevEnviron = &Environ{
	OAuthClientID:     "76f79ece5df3434388a68ec221557f22",
	OAuthClientSecret: "4c111337c81e4415a12222d62067dacb",
	ConfigOpts: &configOptions{
		Cluster:        "dev-k.yandex-team.ru",
		Server:         "https://dev-k.yandex-team.ru",
		User:           "dev-k.yandex-team.ru",
		Context:        "dev-k.yandex-team.ru",
		ContextAliases: []string{"dev-k"},
	},
	TvmAliases: map[string][]uint64{
		"deployctl": {2033929, 2032364},
		"awacsctl":  {2035689, 2032364},
	},
}

var Environs = map[string]*Environ{}

var DefaultEnviron = ProdEnviron

func GetCurrentEnviron() *Environ {
	config, err := kubeconfig.GetKubeClientConfig().RawConfig()
	if err != nil {
		return DefaultEnviron
	}
	env, ok := Environs[config.CurrentContext]
	if !ok {
		return DefaultEnviron
	}
	return env
}

func (e *Environ) ResolveTvmIDs(idsAndAliases []string) ([]uint64, error) {
	var out []uint64
	for _, idOrAlias := range idsAndAliases {
		if id, err := strconv.ParseUint(idOrAlias, 10, 64); err == nil {
			out = append(out, id)
		} else {
			if items, ok := e.TvmAliases[idOrAlias]; ok {
				out = append(out, items...)
			} else {
				return nil, fmt.Errorf("unknown tvm receiver: %v", idOrAlias)
			}
		}
	}
	return out, nil
}

func init() {
	environs := []*Environ{ProdEnviron, DevEnviron}
	for _, env := range environs {
		Environs[env.ConfigOpts.Context] = env
		for _, alias := range env.ConfigOpts.ContextAliases {
			Environs[alias] = env
		}
	}
}
