package kubeconfig

import (
	"sync"

	"k8s.io/client-go/tools/clientcmd"
)

var (
	Path       string
	config     clientcmd.ClientConfig
	configOnce sync.Once
)

func GetKubeClientConfig() clientcmd.ClientConfig {
	configOnce.Do(func() {
		config = clientcmd.NewNonInteractiveDeferredLoadingClientConfig(
			&clientcmd.ClientConfigLoadingRules{ExplicitPath: Path},
			&clientcmd.ConfigOverrides{},
		)

	})
	return config
}
