package quantities

import (
	"fmt"
	"k8s.io/apimachinery/pkg/api/resource"
	"regexp"
)

func ConvertToBinary(value string) string {
	regex := regexp.MustCompile("([mkMGTPE])$")
	value = regex.ReplaceAllString(value, "${1}i")
	return value
}

func ConvertFromHuman(value string) (uint64, error) {
	value = ConvertToBinary(value)
	if len(value) == 0 {
		return 0, nil
	}

	q, err := resource.ParseQuantity(value)
	if err != nil {
		return 0, err
	}
	if q.Sign() < 0 {
		return 0, fmt.Errorf("expected positive quantity")
	}

	val, ok := q.AsInt64()
	if ok {
		return uint64(val), nil
	} else {
		val, ok = q.AsDec().Unscaled()
		if ok {
			return uint64(val), nil
		}
	}

	return 0, fmt.Errorf("invalid format")
}
