package quantities

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestConvertFromHuman(t *testing.T) {
	t.Parallel()

	t.Run("error", func(t *testing.T) {
		t.Parallel()
		testCases := []string{
			"invalid", "-42",
		}

		for _, tc := range testCases {
			tc := tc
			t.Run(tc, func(t *testing.T) {
				t.Parallel()
				_, err := ConvertFromHuman(tc)
				require.Error(t, err)
			})
		}
	})

	t.Run("ok", func(t *testing.T) {
		t.Parallel()
		testCases := []struct {
			value  string
			result uint64
		}{
			{"", 0},
			{"12M", 12 * 1024 * 1024},
		}

		for _, tc := range testCases {
			tc := tc
			t.Run(tc.value, func(t *testing.T) {
				t.Parallel()
				result, err := ConvertFromHuman(tc.value)
				require.NoError(t, err)
				require.Equal(t, tc.result, result)
			})
		}
	})
}
