package scheme

import (
	utilruntime "k8s.io/apimachinery/pkg/util/runtime"
	"k8s.io/client-go/kubernetes/scheme"

	abv1 "a.yandex-team.ru/infra/infractl/controllers/awacs/api/backend/v1"
	auv1 "a.yandex-team.ru/infra/infractl/controllers/awacs/api/upstream/v1"
	dpv1 "a.yandex-team.ru/infra/infractl/controllers/deploy/api/project/v1"
	dsv1 "a.yandex-team.ru/infra/infractl/controllers/deploy/api/stage/v1"
	rv1 "a.yandex-team.ru/infra/infractl/controllers/runtime/api/v1"
	sev1 "a.yandex-team.ru/infra/infractl/models/serviceendpoint/v1"
)

func init() {
	utilruntime.Must(dpv1.AddToScheme(scheme.Scheme))
	utilruntime.Must(dsv1.AddToScheme(scheme.Scheme))
	utilruntime.Must(rv1.AddToScheme(scheme.Scheme))
	utilruntime.Must(auv1.AddToScheme(scheme.Scheme))
	utilruntime.Must(abv1.AddToScheme(scheme.Scheme))
	utilruntime.Must(sev1.AddToScheme(scheme.Scheme))
}
